# Images Directory

This directory contains time-mapped background images for the TeaHouse Hero block.

## File Naming Convention

Images should be named according to the time mapping algorithm:

- `00.jpg` - Midnight (00:00-00:59)
- `02.jpg` - 2 AM (01:00-02:59) 
- `04.jpg` - 4 AM (03:16-04:59) *Special: 03:16+ maps to 04*
- `06.jpg` - 6 AM (05:00-06:59)
- `08.jpg` - 8 AM (07:00-08:59)
- `10.jpg` - 10 AM (09:00-10:59)
- `12.jpg` - Noon (11:00-12:59)
- `14.jpg` - 2 PM (13:00-14:59)
- `16.jpg` - 4 PM (15:00-16:59)
- `18.jpg` - 6 PM (17:00-18:59)
- `20.jpg` - 8 PM (19:00-20:59)
- `22.jpg` - 10 PM (21:00-22:59)
- `0314.jpg` - Special case for exactly 03:14

## Time Mapping Logic

- **03:14 exactly** → `0314.jpg`
- **03:16-03:59** → `04.jpg` 
- **Even hours** → `HH.jpg` (zero-padded)
- **Odd hours** → `(HH-1).jpg` (previous even hour)

## File Requirements

- **Format**: Use the file extension specified in the block settings (default: jpg)
- **Size**: Recommended minimum 1920x1080 for full coverage
- **Optimization**: Compress images for web delivery
- **Accessibility**: Ensure sufficient contrast for overlaid text

## Usage

The TeaHouse Hero block will automatically:
1. Resolve `images/` path to this plugin directory
2. Load the appropriate image based on visitor's local time
3. Update every minute with smooth transitions
4. Preload the next minute's image for seamless changes
