/**
 * Constants for TeaHouse Hero block.
 *
 * Configurable constants for timeouts, intervals, and other settings.
 *
 * @package
 */

// Timer intervals (in milliseconds)
export const TIMERS = {
	// Image preload timeout
	PRELOAD_TIMEOUT: 5000, // 5 seconds

	// Background update interval
	UPDATE_INTERVAL: 60000, // 1 minute (60 seconds)
};

// Default block settings
export const DEFAULTS = {
	USE_UPSCALED: true,
	FILE_EXTENSION: 'jpg',
	CONTENT_ALIGNMENT: 'center',
	OVERLAY_COLOR: '#000000',
	OVERLAY_OPACITY: 0.4,
	ENABLE_NOISE: true,
	NOISE_OPACITY: 0.025,
	NOISE_SCALE: 50,
	NOISE_TYPE: 'fractalNoise',
	NOISE_OCTAVES: 4,
	NOISE_FREQUENCY: 0.9,
	NOISE_SEED: 1,
	NOISE_COLOR_TYPE: 'monochrome',
	NOISE_COLOR: '#ffffff',
};

// WordPress block template
export const DEFAULT_TEMPLATE = [
	[ 'core/heading', { placeholder: 'Hero heading…' } ],
	[
		'core/paragraph',
		{
			placeholder: 'Hero description or message.',
		},
	],
	[ 'core/buttons' ],
];

// Content alignment options
export const ALIGN_OPTIONS = [
	{ label: 'Top', value: 'top' },
	{ label: 'Center', value: 'center' },
	{ label: 'Bottom', value: 'bottom' },
];
